/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.demo.extras;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.extras.components.FlatTriStateCheckBox;
import com.formdev.flatlaf.util.HSLColor;
import java.awt.Color;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;

public class ExtrasPanel
extends JPanel {
    private Timer rainbowIconTimer;
    private int rainbowCounter = 0;
    private JLabel label4;
    private JLabel label1;
    private FlatTriStateCheckBox triStateCheckBox1;
    private JLabel triStateLabel1;
    private JLabel label2;
    private JPanel svgIconsPanel;
    private JLabel label3;
    private JSeparator separator1;
    private JLabel label5;
    private JLabel label6;
    private JLabel rainbowIcon;
    private JLabel label7;
    private JToggleButton redToggleButton;
    private JToggleButton brighterToggleButton;

    public ExtrasPanel() {
        this.initComponents();
        this.triStateLabel1.setText(this.triStateCheckBox1.getState().toString());
        this.addSVGIcon("actions/copy.svg");
        this.addSVGIcon("actions/colors.svg");
        this.addSVGIcon("actions/execute.svg");
        this.addSVGIcon("actions/suspend.svg");
        this.addSVGIcon("actions/intentionBulb.svg");
        this.addSVGIcon("actions/quickfixOffBulb.svg");
        this.addSVGIcon("objects/abstractClass.svg");
        this.addSVGIcon("objects/abstractMethod.svg");
        this.addSVGIcon("objects/annotationtype.svg");
        this.addSVGIcon("objects/annotationtype.svg");
        this.addSVGIcon("objects/css.svg");
        this.addSVGIcon("objects/javaScript.svg");
        this.addSVGIcon("objects/xhtml.svg");
        this.addSVGIcon("errorDialog.svg");
        this.addSVGIcon("informationDialog.svg");
        this.addSVGIcon("warningDialog.svg");
        this.initRainbowIcon();
    }

    private void initRainbowIcon() {
        FlatSVGIcon icon = new FlatSVGIcon("com/formdev/flatlaf/demo/extras/svg/informationDialog.svg");
        icon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> {
            ++this.rainbowCounter;
            this.rainbowCounter %= 255;
            return Color.getHSBColor((float)this.rainbowCounter / 255.0f, 1.0f, 1.0f);
        }));
        this.rainbowIcon.setIcon(icon);
        this.rainbowIconTimer = new Timer(30, e -> this.rainbowIcon.repaint());
        this.addHierarchyListener(e -> {
            if (e.getID() == 1400 && (e.getChangeFlags() & 4L) != 0L) {
                if (this.isShowing()) {
                    this.rainbowIconTimer.start();
                } else {
                    this.rainbowIconTimer.stop();
                }
            }
        });
    }

    private void addSVGIcon(String name) {
        this.svgIconsPanel.add(new JLabel(new FlatSVGIcon("com/formdev/flatlaf/demo/extras/svg/" + name)));
    }

    private void triStateCheckBox1Changed() {
        this.triStateLabel1.setText(this.triStateCheckBox1.getState().toString());
    }

    private void redChanged() {
        this.brighterToggleButton.setSelected(false);
        Function<Color, Color> mapper = null;
        if (this.redToggleButton.isSelected()) {
            float[] redHSL = HSLColor.fromRGB(Color.red);
            mapper = color -> {
                float[] hsl = HSLColor.fromRGB(color);
                return HSLColor.toRGB(redHSL[0], 70.0f, hsl[2]);
            };
        }
        FlatSVGIcon.ColorFilter.getInstance().setMapper(mapper);
        SwingUtilities.windowForComponent(this).repaint();
    }

    private void brighterChanged() {
        this.redToggleButton.setSelected(false);
        FlatSVGIcon.ColorFilter.getInstance().setMapper(this.brighterToggleButton.isSelected() ? color -> color.brighter().brighter() : null);
        SwingUtilities.windowForComponent(this).repaint();
    }

    private void initComponents() {
        this.label4 = new JLabel();
        this.label1 = new JLabel();
        this.triStateCheckBox1 = new FlatTriStateCheckBox();
        this.triStateLabel1 = new JLabel();
        this.label2 = new JLabel();
        this.svgIconsPanel = new JPanel();
        this.label3 = new JLabel();
        this.separator1 = new JSeparator();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.rainbowIcon = new JLabel();
        this.label7 = new JLabel();
        this.redToggleButton = new JToggleButton();
        this.brighterToggleButton = new JToggleButton();
        this.setLayout(new MigLayout("insets dialog,hidemode 3", "[][][left]", "[]para[][][][][][][]"));
        this.label4.setText("Note: Components on this page require the flatlaf-extras library.");
        this.add((Component)this.label4, "cell 0 0 3 1");
        this.label1.setText("TriStateCheckBox:");
        this.add((Component)this.label1, "cell 0 1");
        this.triStateCheckBox1.setText("Three States");
        this.triStateCheckBox1.addActionListener(e -> this.triStateCheckBox1Changed());
        this.add((Component)this.triStateCheckBox1, "cell 1 1");
        this.triStateLabel1.setText("text");
        this.triStateLabel1.setEnabled(false);
        this.add((Component)this.triStateLabel1, "cell 2 1,gapx 30");
        this.label2.setText("SVG Icons:");
        this.add((Component)this.label2, "cell 0 2");
        this.svgIconsPanel.setLayout(new MigLayout("insets 0,hidemode 3", "[fill]", "[grow,center]"));
        this.add((Component)this.svgIconsPanel, "cell 1 2 2 1");
        this.label3.setText("The icons may change colors when switching to another theme.");
        this.add((Component)this.label3, "cell 1 3 2 1");
        this.add((Component)this.separator1, "cell 1 4 2 1,growx");
        this.label5.setText("Color filters can be also applied to icons. Globally or for each instance.");
        this.add((Component)this.label5, "cell 1 5 2 1");
        this.label6.setText("Rainbow color filter");
        this.add((Component)this.label6, "cell 1 6 2 1");
        this.add((Component)this.rainbowIcon, "cell 1 6 2 1");
        this.label7.setText("Global icon color filter");
        this.add((Component)this.label7, "cell 1 7 2 1");
        this.redToggleButton.setText("Toggle RED");
        this.redToggleButton.addActionListener(e -> this.redChanged());
        this.add((Component)this.redToggleButton, "cell 1 7 2 1");
        this.brighterToggleButton.setText("Toggle brighter");
        this.brighterToggleButton.addActionListener(e -> this.brighterChanged());
        this.add((Component)this.brighterToggleButton, "cell 1 7 2 1");
    }
}

